import { world, system, ItemStack } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:tabilo_egg_stage0', {
        onTick: ({ block }) => {
            const stage = block.permutation.withState("v360:crack_bit", 1);
            block.setPermutation(stage);
            block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${Object.values(block.location).join(' ')}`);
            block.dimension.playSound("block.sniffer_egg.crack", block.location);
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:tabilo_egg_stage1', {
        onTick: ({ block }) => {
            const stage = block.permutation.withState("v360:crack_bit", 2);
            block.setPermutation(stage);
            block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${Object.values(block.location).join(' ')}`);
            block.dimension.playSound("block.sniffer_egg.crack", block.location);
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:tabilo_egg_stage2', {
        onTick: ({ block }) => {
            block.dimension.runCommand(`setblock ${Object.values(block.location).join(' ')} air destroy`);
            block.dimension.runCommand(`summon v360:muppet ${Object.values(block.location).join(' ')} ~~ tabilo_baby`);
            block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${Object.values(block.location).join(' ')}`)
            block.dimension.playSound("block.sniffer_egg.hatch", block.location);
        }
    })
})